% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_sparta.R
\name{sparta_struct}
\alias{sparta_struct}
\title{Construct sparta object}
\usage{
sparta_struct(x, vals, dim_names)
}
\arguments{
\item{x}{matrix where columns represents cells in an array-like object}

\item{vals}{vector of values corresponding to x}

\item{dim_names}{a named list}
}
\value{
A sparta object
}
\description{
Helper function to construct a sparta object with given values and dim names
}
\examples{
x <- array(
  c(1,0,0,2,3,4,0,0),
  dim = c(2,2,2),
  dimnames = list(
    a = c("a1", "a2"),
    b = c("b1", "b2"),
    c = c("c1", "c2")
  )
)

sx <- as_sparta(x)
sparta_struct(unclass(sx), vals(sx), dim_names(sx))
}
