% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionFuns.R
\name{bounding_const_M}
\alias{bounding_const_M}
\title{Compute the bounding constant for acceptance-rejection sampling}
\usage{
bounding_const_M(nu, lambda)
}
\arguments{
\item{nu}{the degrees of freedom parameter value, a numeric scalar strictly larger than two.}

\item{lambda}{the skewness parameter value, a numeric scalar strictly between -1 and 1.}
}
\value{
Returns a numeric scalar representing the estimated bounding constant \eqn{M} to be used in the acceptance-rejection
 sampling algorithm.
}
\description{
\code{bounding_const_M} calculates the bounding constant \eqn{M} used in the acceptance-rejection sampling algorithm
 for the univariate skewed \emph{t}-distribution described in Hansen (1994)
}
\details{
The function computes the bounding constant \eqn{M} required for the acceptance-rejection sampling method by evaluating
 the ratio of the skewed \emph{t}-density (\code{\link{skewed_t_dens}}) to the standard \emph{t}-density (\code{\link{stand_t_dens}})
 over a grid of \eqn{y} values ranging from \eqn{-10} to \eqn{10}. To improve the efficiency of the sampling algorithm, the degrees
 of freedom parameter for the proposal distribution is set to the minimum of \code{nu} and \eqn{3}, ensuring heavier tails in the
 proposal distribution when \code{nu} is large. A safety margin of 10\% is added to the maximum ratio to account for numerical
 inaccuracies and ensure that the inequality \eqn{f(y) \leq M \cdot q(y)} holds over the entire support.
}
\references{
\itemize{
   \item Hansen B.E. 1994. Autoregressive Conditional Density estimation. \emph{Journal of Econometrics}, \strong{35}:3, 705-730.
 }
}
\keyword{internal}
