% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-synthetic-data.R
\name{make_synthetic_data}
\alias{make_synthetic_data}
\title{Outputs a synthetic survey using a simple model}
\usage{
make_synthetic_data(
  nrow,
  ncol,
  minority = NULL,
  correlation = NULL,
  polarisation = NULL,
  likert = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{nrow}{The number of rows in the survey}

\item{ncol}{The number of columns in the survey}

\item{minority}{The fraction of nodes in the smaller of the two polarised groups}

\item{correlation}{Probability that group item corresponds to polarisation}

\item{polarisation}{The degree of polarisation among the system's agents}

\item{likert}{Range of the Likert scale}

\item{seed}{Seed value for random number generation.}

\item{...}{Mostly used to handle arguments with alternative spellings.}
}
\value{
A data frame corresponding to a survey.
}
\description{
\code{make_synthetic_data()} outputs a synthetic survey, generated using a simple, stochastic
model of polarisation.
}
\examples{
S <- make_synthetic_data(200, 8)
}
