% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_assign.R
\name{tar_assign}
\alias{tar_assign}
\title{An assignment-based pipeline DSL}
\usage{
tar_assign(targets)
}
\arguments{
\item{targets}{An expression with special syntax to define a
collection of targets in a pipeline.
Example: \code{tar_assign(x <- tar_target(get_data()))} is equivalent
to \code{list(tar_target(x, get_data()))}.
The rules of the syntax
are as follows:
\itemize{
\item The code supplied to \code{\link[=tar_assign]{tar_assign()}} must be enclosed in curly braces
beginning with \verb{\{} and \verb{\}} unless it only contains a
one-line statement or uses \code{=} as the assignment.
\item Each statement in the code block must be of the form
\code{x <- f()}, or \code{x = f()} where \code{x} is the name of a target and
\code{f()} is a function like \code{tar_target()} or \code{\link[=tar_quarto]{tar_quarto()}}
which accepts a \code{name} argument.
\item The native pipe operator \verb{|>} is allowed because it lazily
evaluates its arguments and be converted into non-pipe syntax
without evaluating the code.
}}
}
\value{
A list of \code{tar_target()} objects.
See the "Target objects" section for background.
}
\description{
An assignment-based domain-specific language for pipeline
construction.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
write.csv(airquality, "data.csv", row.names = FALSE)
targets::tar_script({
  library(tarchetypes)
  tar_option_set(packages = c("readr", "dplyr", "ggplot2"))
  tar_assign({
    file <- tar_target("data.csv", format = "file")

    data <- read_csv(file, col_types = cols()) |>
      filter(!is.na(Ozone)) |>
      tar_target()

    model = lm(Ozone ~ Temp, data) |>
      coefficients() |>
      tar_target()

    plot <- {
        ggplot(data) +
          geom_point(aes(x = Temp, y = Ozone)) +
          geom_abline(intercept = model[1], slope = model[2]) +
          theme_gray(24)
      } |>
        tar_target()
  })
})
targets::tar_make()
})
}
}
\concept{Domain-specific languages for pipeline construction}
