% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_data_summary.R
\name{module_data_summary}
\alias{module_data_summary}
\alias{ui_data_summary}
\alias{srv_data_summary}
\alias{get_filter_overview_wrapper}
\alias{get_filter_overview}
\alias{get_filter_overview_array}
\alias{get_filter_overview_MultiAssayExperiment}
\title{Data summary}
\usage{
ui_data_summary(id)

srv_data_summary(id, data)

get_filter_overview_wrapper(teal_data)

get_filter_overview(current_data, initial_data, dataname, subject_keys)

get_filter_overview_array(current_data, initial_data, dataname, subject_keys)

get_filter_overview_MultiAssayExperiment(current_data, initial_data, dataname)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{data}{(\code{reactive} returning \code{teal_data})}

\item{current_data}{(\code{object}) current object (after filtering and transforming).}

\item{initial_data}{(\code{object}) initial object.}

\item{dataname}{(\code{character(1)})}

\item{subject_keys}{(\code{character}) names of the columns which determine a single unique subjects}
}
\value{
\code{NULL}.
}
\description{
Module and its utils to display the number of rows and subjects in the filtered and unfiltered data.
}
\details{
Handling different data classes:
\code{get_filter_overview()} is a pseudo S3 method which has variants for:
\itemize{
\item \code{array} (\code{data.frame}, \code{DataFrame}, \code{array}, \code{Matrix} and \code{SummarizedExperiment}): Method variant
can be applied to any two-dimensional objects on which \code{\link[=ncol]{ncol()}} can be used.
\item \code{MultiAssayExperiment}: for which summary contains counts for \code{colData} and all \code{experiments}.
\item For other data types module displays data name with warning icon and no more details.
}

Module includes also "Show/Hide unsupported" button to toggle rows of the summary table
containing datasets where number of observations are not calculated.
}
\keyword{internal}
