% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_transform_module.R
\name{teal_transform_module}
\alias{teal_transform_module}
\title{Data module for \code{teal} transformations and output customization}
\usage{
teal_transform_module(
  ui = NULL,
  server = function(id, data) data,
  label = "transform module",
  datanames = "all"
)
}
\arguments{
\item{ui}{(\verb{function(id)})
\code{shiny} module UI function; must only take \code{id} argument}

\item{server}{(\verb{function(id, data)} or \code{expression})
A \code{shiny} module server function that takes \code{id} and \code{data} as arguments, where \code{id} is the module id and \code{data}
is the reactive \code{teal_data} input. The \code{server} function must return a reactive expression containing a \code{teal_data}
object. For simplified syntax, use \code{\link[=make_teal_transform_server]{make_teal_transform_server()}}.}

\item{label}{(\code{character(1)}) Label of the module.}

\item{datanames}{(\code{character})
Specifies the names of datasets relevant to the module. Only filters for the specified \code{datanames} will be displayed
in the filter panel. The keyword \code{"all"} can be used to display filters for all datasets. \code{datanames} are
automatically appended to the \code{\link[=modules]{modules()}} \code{datanames}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{teal_transform_module} provides a \code{shiny} module that enables data transformations within a \code{teal} application
and allows for customization of outputs generated by modules.
}
\section{Transforming Module Inputs in \code{teal}}{
Data transformations occur after data has been filtered in \code{teal}.
The transformed data is then passed to the \code{server} of \code{\link[=teal_module]{teal_module()}} and managed by \code{teal}'s internal processes.
The primary advantage of \code{teal_transform_module} over custom modules is in its error handling, where all warnings and
errors are managed by \code{teal}, allowing developers to focus on transformation logic.

For more details, see the vignette: \code{vignette("transform-input-data", package = "teal")}.
}

\section{Customizing Module Outputs}{
\code{teal_transform_module} also allows developers to modify any object created within \code{\link[teal.data:teal_data]{teal.data::teal_data}}.
This means you can use it to customize not only datasets but also tables, listings, and graphs.
Some \code{\link{teal_modules}} permit developers to inject custom \code{shiny} modules to enhance displayed outputs.
To manage these \code{decorators} within your module, use \code{\link[=ui_transform_teal_data]{ui_transform_teal_data()}} and \code{\link[=srv_transform_teal_data]{srv_transform_teal_data()}}.
(For further guidance on managing decorators, refer to \code{ui_args} and \code{srv_args} in the vignette documentation.)

See the vignette \code{vignette("transform-module-output", package = "teal")} for additional examples.
}

\section{\code{server} as a language}{
The \code{server} function in \code{teal_transform_module} must return a reactive \code{\link[teal.data:teal_data]{teal.data::teal_data}} object.
For simple transformations without complex reactivity, the \code{server} function might look like this:s

\if{html}{\out{<div class="sourceCode">}}\preformatted{function(id, data) \{
  moduleServer(id, function(input, output, session) \{
    reactive(\{
      within(
        data(),
        expr = x <- subset(x, col == level),
        level = input$level
      )
    \})
  \})
\}
}\if{html}{\out{</div>}}

The example above can be simplified using \code{make_teal_transform_server}, where \code{level} is automatically matched to the
corresponding \code{input} parameter:

\if{html}{\out{<div class="sourceCode">}}\preformatted{make_teal_transform_server(expr = expression(x <- subset(x, col == level)))
}\if{html}{\out{</div>}}
}

\examples{
data_transformators <- list(
  teal_transform_module(
    label = "Static transformator for iris",
    datanames = "iris",
    server = function(id, data) {
      moduleServer(id, function(input, output, session) {
        reactive({
          within(data(), {
            iris <- head(iris, 5)
          })
        })
      })
    }
  ),
  teal_transform_module(
    label = "Interactive transformator for iris",
    datanames = "iris",
    ui = function(id) {
      ns <- NS(id)
      tags$div(
        numericInput(ns("n_cols"), "Show n columns", value = 5, min = 1, max = 5, step = 1)
      )
    },
    server = function(id, data) {
      moduleServer(id, function(input, output, session) {
        reactive({
          within(data(),
            {
              iris <- iris[, 1:n_cols]
            },
            n_cols = input$n_cols
          )
        })
      })
    }
  )
)

output_decorator <- teal_transform_module(
  server = make_teal_transform_server(
    expression(
      object <- rev(object)
    )
  )
)

app <- init(
  data = teal_data(iris = iris),
  modules = example_module(
    transformators = data_transformators,
    decorators = list(output_decorator)
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIEATKKSgB9UswgBnJUUYxLLh3MV0HpdgOlpLmpbeycXGGsYIjMVajh-CEDA6ih6OGppAF5pPjAAZStxAiCw51d3RmUXaVpGWgc83ADkiytoeE8cvLqGppbAhxEpKpzVdXEtWjNcaTaoHRAB5OjY+PzhkXZp2fGNKYhUFVJZomOjk+khhwdNCEXl5OlGOCgNKXYlpKefgHdaUgACyE7Hm2lmXx+UNq9U8CmkgNeZm2sNmAFZ+N9odIAL6Y7F4x64-HJHEtHjNb7BUJQRzlSKrOIJZapdKZbpgACSwlE4ikpVp4QqpBq5RhfTwy3mHTgXVyYF6jUlWOkKlo2WUan2EG2ZgeKsCji80gAcvldSSnlYAOYOAAkZkkiWxEBU8HqBG5F3Yjn8kGsxGoSop8vygKIv2kSUDbscTWkEm4KhkOTRsxgQg1AEZ01AAB4atNXciobOW5LlnGUp5DRgjDV7SY6nZzSwLaSQn6M9abRi63ZapvbQ7HU7nUdXWW3Ej67EvN58hKd7H-IEgsEUolQ5fY5KK42K4CzLOICABohBgC6W5+VZvTzPgblQgudsfF8aBp+5aehK-f9-ckBExAQzlIC5rDMOBiGYEUqnhak7EFekohiJlnUnOsRA1NwAGs4FsV4QiQukImsWsRgwwI4DzVAXhuO4qOSIh6AAK2g0hjReCR2BY9ixHLElMRA6B0APQQ-BaeYNWpMF9xyRVN2+btZQ1GjYFQeJULWZkVRIoU3DguV5hpUjhQ8atWmglxKjlHw-DAiCoJgyohOAgRaCUaRh3IXlJASHhZyuYEIFYABBdB2DQVA7TVWZortCiRExMkIDAHFLyAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIEATKKSgB9UswgBnJUUYxLLh3MV0HpdgOlpLmpbeycXGGsYIjMVajh-CEDA6ih6OGppAF5pPjAAZStxAiCw51d3RmUXaVpGWgc83ADkiytoeE8cvLqGppbAhxEpKpzVdXEtWjNcaTaoHRAB5OjY+PzhkXZp2fGNKYhUFVJZomOjk+khhwdNCEXl5OlGOCgNKXYlpKefgHdaUgACyE7Hm2lmXx+UNq9U8CmkgNeZm2sNmAFZ+N9odIAL6Y7F4x64-HJHEtHjNb7BUJQRzlSKrOIJZapdKZbpgACSwlE4ikpVp4QqpBq5RhfTwy3mHTgXVyYF6jUlWOkKlo2WUan2EG2ZgeKsCji80gAcvldSSnlYAOYOAAkZkkiWxEBU8HqBG5F3Yjn8kGsxGoSop8vygKIv2kSUDbscTWkEm4KhkOTRsxgQg1AEZ01AAB4atNXciobOW5LlnGUp5DRgjDV7SY6nZzSwLaSQn6M9abRi63ZapvbQ7HU7nUdXWW3Ej67EvN58hKd7H-IEgsEUolQ5fY5KK42K4CzLOICABohBgC6W5+VZvTzPgblQgudsfF8aBp+5aehK-f9-ckBExAQzlIC5rDMOBiGYEUqnhak7EFekohiJlnUnOsRA1NwAGs4FsV4QiQukImsWsRgwwI4DzVAXhuO4qOSIh6AAK2g0hjReCR2BY9ixHLElMRA6B0APQQ-BaeYNWpMF9xyRVN2+btZQ1GjYFQeJULWZkVRIoU3DguV5hpUjhQ8atWmglxKjlHw-DAiCoJgyohOAgRaCUaRh3IXlJASHhZyuYEIFYABBdB2DQVA7TVWZortCiRExMkIDAHFLyAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

