% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_text.R
\name{shape_text}
\alias{shape_text}
\title{Calculate glyph positions for strings}
\usage{
shape_text(
  strings,
  id = NULL,
  family = "",
  italic = FALSE,
  weight = "normal",
  width = "undefined",
  features = font_feature(),
  size = 12,
  res = 72,
  lineheight = 1,
  align = "auto",
  hjust = 0,
  vjust = 0,
  max_width = NA,
  tracking = 0,
  indent = 0,
  hanging = 0,
  space_before = 0,
  space_after = 0,
  direction = "auto",
  path = NULL,
  index = 0,
  bold = deprecated()
)
}
\arguments{
\item{strings}{A character vector of strings to shape}

\item{id}{A vector grouping the strings together. If strings share an id the
shaping will continue between strings}

\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{weight}{The weight to query for, either in numbers (\code{0}, \code{100}, \code{200},
\code{300}, \code{400}, \code{500}, \code{600}, \code{700}, \code{800}, or \code{900}) or strings (\code{"undefined"},
\code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"}, \code{"medium"}, \code{"semibold"},
\code{"bold"}, \code{"ultrabold"}, or \code{"heavy"}). \code{NA} will be interpreted as
\code{"undefined"}/\code{0}}

\item{width}{The width to query for either in numbers (\code{0}, \code{1}, \code{2},
\code{3}, \code{4}, \code{5}, \code{6}, \code{7}, \code{8}, or \code{9}) or strings (\code{"undefined"},
\code{"ultracondensed"}, \code{"extracondensed"}, \code{"condensed"}, \code{"semicondensed"},
\code{"normal"}, \code{"semiexpanded"}, \code{"expanded"}, \code{"extraexpanded"}, or
\code{"ultraexpanded"}). \code{NA} will be interpreted as \code{"undefined"}/\code{0}}

\item{features}{A \code{\link[systemfonts:font_feature]{systemfonts::font_feature()}} object or a list of them,
giving the OpenType font features to set}

\item{size}{The size in points to use for the font}

\item{res}{The resolution to use when doing the shaping. Should optimally
match the resolution used when rendering the glyphs.}

\item{lineheight}{A multiplier for the lineheight}

\item{align}{Within text box alignment, either \code{'auto'}, \code{'left'}, \code{'center'},
\code{'right'}, \code{'justified'}, \code{'justified-left'}, \code{'justified-right'},
\code{'justified-center'}, or \code{'distributed'}. \code{'auto'} and \code{'justified'} will
chose the left or right version depending on the direction of the text.}

\item{hjust, vjust}{The justification of the textbox surrounding the text}

\item{max_width}{The requested with of the string in inches. Setting this to
something other than \code{NA} will turn on word wrapping.}

\item{tracking}{Tracking of the glyphs (space adjustment) measured in 1/1000
em.}

\item{indent}{The indent of the first line in a paragraph measured in inches.}

\item{hanging}{The indent of the remaining lines in a paragraph measured in
inches.}

\item{space_before, space_after}{The spacing above and below a paragraph,
measured in points}

\item{direction}{The overall directional flow of the text. The default
(\code{"auto"}) will guess the direction based on the content of the string. Use
\code{"ltr"} (left-to-right) and \code{"rtl"} (right-to-left) to turn detection of and
set it manually.}

\item{path, index}{path an index of a font file to circumvent lookup based on
family and style}

\item{bold}{logical indicating whether the font weight}
}
\value{
A list with two element: \code{shape} contains the position of each glyph,
relative to the origin in the enclosing textbox. \code{metrics} contain metrics
about the full strings.

\code{shape} is a data.frame with the following columns:
\describe{
\item{glyph}{The placement of the the first character contributing to the glyph within the string}
\item{index}{The index of the glyph in the font file}
\item{metric_id}{The index of the string the glyph is part of (referencing a row in the \code{metrics} data.frame)}
\item{string_id}{The index of the string the glyph came from (referencing an element in the \code{strings} input)}
\item{x_offset}{The x offset in pixels from the origin of the textbox}
\item{y_offset}{The y offset in pixels from the origin of the textbox}
\item{font_path}{The path to the font file used during shaping of the glyph}
\item{font_index}{The index of the font used to shape the glyph in the font file}
\item{font_size}{The size of the font used during shaping}
\item{advance}{The advancement amount to the next glyph}
\item{ascender}{The ascend of the font used for the glyph. This does not measure the actual glyph}
\item{descender}{The descend of the font used for the glyph. This does not measure the actual glyph}
}

\code{metrics} is a data.frame with the following columns:
\describe{
\item{string}{The text the string consist of}
\item{width}{The width of the string}
\item{height}{The height of the string}
\item{left_bearing}{The distance from the left edge of the textbox and the leftmost glyph}
\item{right_bearing}{The distance from the right edge of the textbox and the rightmost glyph}
\item{top_bearing}{The distance from the top edge of the textbox and the topmost glyph}
\item{bottom_bearing}{The distance from the bottom edge of the textbox and the bottommost glyph}
\item{left_border}{The position of the leftmost edge of the textbox related to the origin}
\item{top_border}{The position of the topmost edge of the textbox related to the origin}
\item{pen_x}{The horizontal position of the next glyph after the string}
\item{pen_y}{The vertical position of the next glyph after the string}
\item{ltr}{The global direction of the string. If \code{TRUE} then it is left-to-right, otherwise it is right-to-left}
}
}
\description{
Performs advanced text shaping of strings including font fallbacks,
bidirectional script support, word wrapping and various character and
paragraph level formatting settings.
}
\examples{
string <- "This is a long string\nLook; It spans multiple lines\nand all"

# Shape with default settings
shape_text(string)

# Mix styles within the same string
string <- c(
  "This string will have\na ",
  "very large",
  " text style\nin the middle"
)

shape_text(string, id = c(1, 1, 1), size = c(12, 24, 12))

}
