% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax-estimate.R
\name{estimate_lavaan}
\alias{estimate_lavaan}
\title{Estimate tidy_sem using 'lavaan'}
\usage{
estimate_lavaan(x, func = "sem", ...)
}
\arguments{
\item{x}{An object of class \code{tidy_sem}.}

\item{func}{The \code{\link[lavaan]{lavaan}} modeling function to invoke,
Default: 'sem'.}

\item{...}{Additional parameters passed to the estimating function.}
}
\value{
An object of class \code{lavaan}.
}
\description{
This function is a wrapper for the \code{\link[lavaan]{lavaan}}
estimating functions. By default, the wrapper uses \code{\link[lavaan]{sem}},
but users can also specify \code{\link[lavaan]{lavaan}},
\code{\link[lavaan]{cfa}}, or \code{\link[lavaan]{growth}}.
}
\examples{
library(lavaan)
model <- tidy_sem(iris, "\\\\.")
model <- measurement(model)
res <- estimate_lavaan(model)
summary(res)
}
