% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-api.R
\name{add_moderator}
\alias{add_moderator}
\title{Adds moderators to the configuration}
\usage{
add_moderator(hte_cfg, model_type, ..., .model_arguments = NULL)
}
\arguments{
\item{hte_cfg}{\code{HTE_cfg} object to update.}

\item{model_type}{Character indicating the model type for these moderators.
Currently two model types are supported: \code{"Stratified"} for discrete moderators
and \code{"KernelSmooth"} for continuous ones.}

\item{...}{The (unquoted) names of the moderator variables.}

\item{.model_arguments}{A named list from argument name to value to pass into the
constructor for the model. See \code{Stratified_cfg} and \code{KernelSmooth_cfg} for more details.}
}
\value{
Updated \code{HTE_cfg} object
}
\description{
This adds a definition about how to display a moderators to
the MCATE config. A moderator is any variable that you want to view information
about CATEs with respect to.
}
\examples{
library("dplyr")
basic_config() \%>\%
   add_moderator("Stratified", x2, x3) \%>\%
   add_moderator("KernelSmooth", x1, x4, x5) -> hte_cfg
}
