% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_groq.R
\name{check_groq_batch}
\alias{check_groq_batch}
\title{Check Batch Processing Status for Groq API}
\usage{
check_groq_batch(
  .llms = NULL,
  .batch_id = NULL,
  .api_url = "https://api.groq.com/",
  .dry_run = FALSE,
  .max_tries = 3,
  .timeout = 60
)
}
\arguments{
\item{.llms}{A list of LLMMessage objects with a batch_id attribute.}

\item{.batch_id}{A character string with the batch ID to check.}

\item{.api_url}{Character; base URL of the Groq API (default: "https://api.groq.com/").}

\item{.dry_run}{Logical; if TRUE, returns the prepared request object without executing (default: FALSE).}

\item{.max_tries}{Maximum retries to perform request.}

\item{.timeout}{Integer specifying the request timeout in seconds (default: 60).}
}
\value{
A tibble with information about the status of batch processing.
}
\description{
This function retrieves the processing status and other details of a specified Groq batch.
}
