% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/business.R
\name{bizday}
\alias{bizday}
\alias{bizday_advance}
\alias{next_bizdays}
\alias{first_bizday_in_month}
\alias{last_bizday_in_month}
\alias{first_bizday_in_quarter}
\alias{last_bizday_in_quarter}
\alias{bizdays_in_month}
\alias{bizdays_in_quarter}
\alias{bizdays_in_year}
\alias{bizday_diff}
\title{Business Days}
\usage{
bizday(d, convention, calendar)

bizday_advance(d, n = 1L, calendar)

next_bizdays(d, n = 1L, calendar)

first_bizday_in_month(m, calendar)

last_bizday_in_month(m, calendar)

first_bizday_in_quarter(q, calendar)

last_bizday_in_quarter(q, calendar)

bizdays_in_month(m, calendar)

bizdays_in_quarter(q, calendar)

bizdays_in_year(y, calendar)

bizday_diff(d1, d2, calendar, start.incl = TRUE, end.incl = FALSE)
}
\arguments{
\item{d}{an object of \code{tind} class or an R object coercible to it, dates.}

\item{convention}{a character value determining date rolling convention, see Details.}

\item{calendar}{a function determining working days and holidays (see Details)
or \code{NULL}.}

\item{n}{an integer vector (for \code{bizday_advance}) or integer value
(for \code{next_bizdays}), numebr of business days.}

\item{m}{an object of \code{tind} class or an R object coercible to it, months.}

\item{q}{an object of \code{tind} class or an R object coercible to it, quarters.}

\item{y}{an object of \code{tind} class or an R object coercible to it, years.}

\item{d1}{an object of \code{tind} class or an R object coercible to it, start dates.}

\item{d2}{an object of \code{tind} class or an R object coercible to it, end dates.}

\item{start.incl}{a logical value, if \code{TRUE}, the starting date is included
in computation of the number of business days between two dates
(\code{TRUE} by default).}

\item{end.incl}{a logical value, if \code{TRUE}, the end date is included
in computation of the number of business days between two dates
(\code{FALSE} by default).}
}
\value{
\code{bizday} and \code{first/last_bizday_in_month/quarter} return
vectors of dates of the same length as their first argument.

\code{bizday_advance} returns a vector of dates of length equal to length
of the longer of the first two arguments (\code{d} and \code{n}).

\code{next_bizdays} returns a vector of dates of length \code{abs(n)}.

\code{bizday_diff} and \code{bizdays_in_month/quarter/year} return integer
vectors.
}
\description{
\code{bizday} computes the nearest business day from the date given
a calendar function and one of the date rolling conventions (see Details).

\code{bizday_advance} advances date(s) by \code{n} business days.

\code{next_bizdays} determines the following \code{n} business days after a date.

\code{first_bizday_in_month/quarter} and \code{last_bizday_in_month/quarter}
determine the first and the last business day in a month and a quarter.

\code{bizdays_in_month},  \code{bizdays_in_quarter}, and \code{bizdays_in_year}
return the number of business days in particular time period.

\code{bizday_diff} computes the number of business days between two dates.
}
\details{
The vectorised implementations of \code{bizday}, \code{bizday_advance},
and \code{next_bizdays} work under the assumption of at least one business day
in a week and could return \code{NA}s for pathological calendar functions.

\code{bizday_advance} with increment 0 will adjust the date to the first
preceding business day if it is not a business day (will act as
\code{bizday(d, "p", *)}).

\code{next_bizdays} accepts negative arguments and returns an increasing
sequence of business dates prior to \code{d} of length \code{abs(n)}.

\strong{Conventions}

The following date rolling conventions are supported (applied when the day
is not a business day):
\describe{
    \item{\code{"p"}}{preceding, the previous business day,}
    \item{\code{"f"}}{following, the next business day,}
    \item{\code{"mp"}}{modified preceding, the previous business day unless
                       it falls in the previous month, in which case the next
                       business day is chosen,}
    \item{\code{"mf"}}{modified following, the next business day unless it
                       falls in the next month, in which case the the
                       previous business day is chosen,}
    \item{\code{"mf2"}}{modified following bimonthly, the next business day
                        unless it falls in the next month or the next half of
                        the month (after 15th), in which case the the previous
                        business day is chosen.}
}

\strong{Calendar Functions}

Calendar function should take a vector of days as an argument and return
a logical vector of the same length marking business days (as \code{TRUE})
or a list of two or three logical vectors of the same length with the first
marking business days. See also \link{calendars} for real-life
examples of calendar functions. When \code{calendar} function is not supplied,
Monday-Friday are marked as business days.
}
\examples{
# a trivial calendar function (Mon-Fri)
monfri <- function(d) (day_of_week(d) <= 5L)
# 2022-10-01 was Saturday
calendar("2022-10", monfri)
(d <- as.date("2022-10-01"))
bizday(d, "p", monfri)
bizday(d, "mp", monfri)
bizday(d, "f", monfri)
bizday(d, "mf", monfri)
bizday(d, "mf2", monfri)
# 2022-10-15 was Saturday again
calendar("2022-10", monfri)
(d <- as.date("2022-10-15"))
bizday(d, "p", monfri)
bizday(d, "mp", monfri)
bizday(d, "f", monfri)
bizday(d, "mf", monfri)
bizday(d, "mf2", monfri)
# 2022-12-31 was also Saturday
calendar("2022-12", monfri)
(d <- as.date("2022-12-31"))
bizday(d, "p", monfri)
bizday(d, "mp", monfri)
bizday(d, "f", monfri)
bizday(d, "mf", monfri)
bizday(d, "mf2", monfri)

}
\seealso{
\code{\link{calendars}} for examples of calendar functions,
\code{\link{daycount_frac}} for computations of day count fractions /
accrual factors.
}
