% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layers_lines.R
\name{tm_lines}
\alias{tm_lines}
\alias{opt_tm_lines}
\title{Map layer: lines}
\usage{
tm_lines(
  col = tm_const(),
  col.scale = tm_scale(),
  col.legend = tm_legend(),
  col.chart = tm_chart_none(),
  col.free = NA,
  lwd = tm_const(),
  lwd.scale = tm_scale(),
  lwd.legend = tm_legend(),
  lwd.chart = tm_chart_none(),
  lwd.free = NA,
  lty = tm_const(),
  lty.scale = tm_scale(),
  lty.legend = tm_legend(),
  lty.chart = tm_chart_none(),
  lty.free = NA,
  col_alpha = tm_const(),
  col_alpha.scale = tm_scale(),
  col_alpha.legend = tm_legend(),
  col_alpha.chart = tm_chart_none(),
  col_alpha.free = NA,
  linejoin = "round",
  lineend = "round",
  plot.order = tm_plot_order("lwd", reverse = TRUE, na.order = "bottom"),
  zindex = NA,
  group = NA,
  group.control = "check",
  popup.vars = NA,
  popup.format = tm_label_format(),
  hover = NA,
  id = "",
  options = opt_tm_lines(),
  ...
)

opt_tm_lines(lines.only = "ifany")
}
\arguments{
\item{col, col.scale, col.legend, col.chart, col.free}{Visual variable that determines the color. See details.}

\item{lwd, lwd.scale, lwd.legend, lwd.chart, lwd.free}{Visual variable that determines the line width. See details.}

\item{lty, lty.scale, lty.legend, lty.chart, lty.free}{Visual variable that determines the line type. See details.}

\item{col_alpha, col_alpha.scale, col_alpha.legend, col_alpha.chart, col_alpha.free}{Visual variable that determines the color transparency. See details.}

\item{linejoin, lineend}{line join and line end. See \link[grid:gpar]{gpar()} for details.}

\item{plot.order}{Specification in which order the spatial features are drawn. See \code{\link[=tm_plot_order]{tm_plot_order()}} for details.}

\item{zindex}{Map layers are drawn on top of each other. The \code{zindex} numbers
(one for each map layer) determines the stacking order.
By default the map layers are drawn in the order they are called.}

\item{group}{Name of the group to which this layer belongs. This is only
relevant in view mode, where layer groups can be switched (see \code{group.control})}

\item{group.control}{In view mode, the group control determines how layer groups
can be switched on and off. Options: \code{"radio"} for radio buttons
(meaning only one group can be shown), \code{"check"} for check boxes
(so multiple groups can be shown), and \code{"none"} for no control
(the group cannot be (de)selected).}

\item{popup.vars}{names of data variables that are shown in the popups
in \code{"view"} mode. Set popup.vars to \code{TRUE} to show all variables in the
shape object. Set popup.vars to \code{FALSE} to disable popups. Set \code{popup.vars}
to a character vector of variable names to those those variables in the popups.
The default (\code{NA}) depends on whether visual variables (e.g.\code{fill}) are used.
If so, only those are shown. If not all variables in the shape object are shown.}

\item{popup.format}{list of formatting options for the popup values. Output of \code{\link[=tm_label_format]{tm_label_format()}}. Only applicable for
numeric data variables. If one list of formatting options is provided,
it is applied to all numeric variables of \code{popup.vars}. Also, a (named)
list of lists can be provided. In that case, each list of formatting options
is applied to the named variable.}

\item{hover}{name of the data variable that specifies the hover labels (view mode only). Set to \code{FALSE} to disable hover labels. By default \code{FALSE}, unless \code{id} is specified. In that case, it is set to \code{id},}

\item{id}{name of the data variable that specifies the indices of the spatial
features. Only used for \code{"view"} mode.}

\item{options}{options passed on to the corresponding \verb{opt_<layer_function>} function}

\item{...}{to catch deprecated arguments from version < 4.0}

\item{lines.only}{should only line geometries of the shape object (defined in \code{\link[=tm_shape]{tm_shape()}}) be plotted, or also other geometry types (like polygons)? By default \code{"ifany"}, which means \code{TRUE} in case a geometry collection is specified.}
}
\description{
Map layer that draws lines. Supported visual variables are: \code{col} (the color), \code{lwd} (line width), \code{lty} (line type), and \code{col_alpha} (color alpha transparency).
}
\details{
The visual variable arguments (e.g. \code{col}) can be specified with either a data
variable name (e.g., a spatial vector attribute or a raster layer of the object
specified in \code{\link[=tm_shape]{tm_shape()}}), or with a visual value (for \code{col}, a color is expected).
See \href{https://r-tmap.github.io/tmap/articles/basics_vv}{vignette about visual variables}.

Multiple values can be specified: in that case facets are created.
These facets can be combined with other faceting data variables, specified with \code{\link[=tm_facets]{tm_facets()}}.
See \href{https://r-tmap.github.io/tmap/articles/basics_facets}{vignette about facets}.
\itemize{
\item The \verb{*.scale} arguments determine the used scale to map the data values to
visual variable values. These can be specified with one of the available
\verb{tm_scale_*()} functions. The default is specified by the tmap option (\code{\link[=tm_options]{tm_options()}}) \code{scales.var}.
See \href{https://r-tmap.github.io/tmap/articles/basics_scales}{vignette about scales}.
\item The \verb{*.legend} arguments determine the used legend, specified with \code{\link[=tm_legend]{tm_legend()}}.
The default legend and its settings are determined by the tmap options (\code{\link[=tm_options]{tm_options()}}) \code{legend.} .
See \href{https://r-tmap.github.io/tmap/articles/basics_legends}{vignette about legends}.
\item The \verb{*.chart} arguments specify additional charts, specified with \code{tm_chart_}, e.g. \code{\link[=tm_chart_histogram]{tm_chart_histogram()}}.
See \href{https://r-tmap.github.io/tmap/articles/basics_charts}{vignette about charts}.
\item The \verb{*.free} arguments determine whether scales are applied freely across facets, or shared.
A logical value is required. They can also be specified with a vector of three
logical values; these determine whether scales are applied freely per facet dimension.
This is only useful when facets are applied (see \code{\link[=tm_facets]{tm_facets()}}).
There are maximally three facet dimensions: rows, columns, and pages. This only
applies for a facet grid (\code{\link[=tm_facets_grid]{tm_facets_grid()}}). For instance, \code{col.free = c(TRUE, FALSE, FALSE)}
means that for the visual variable \code{col}, each row of facets will have its own
scale, and therefore its own legend. For facet wraps and stacks
(\code{\link[=tm_facets_wrap]{tm_facets_wrap()}} and \code{\link[=tm_facets_stack]{tm_facets_stack()}}) there is only one facet dimension,
so the \verb{*.free} argument requires only one logical value.
}
}
\examples{
tm_shape(World_rivers) +
	tm_lines(lwd = "strokelwd",
			 lwd.scale = tm_scale_asis(values.scale = 0.2, value.neutral = 2),
			 col = "scalerank",
			 col.scale = tm_scale_categorical(values = "seaborn.dark"))

tm_shape(World) +
	tm_lines(col = "continent",
			 col.scale = tm_scale_categorical(values = "seaborn.dark"),
			 lty = "continent",
			 lwd = 1.5,
			 lty.legend = tm_legend_combine("col"))
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/examples_terrain}{Terrain map example}
}
