#include <stdbool.h>
#include <stdlib.h>
#include <stdint.h>
//Strongly connected components

struct tjstate {
  uint32_t *index;
  uint32_t *lowlink;
  bool *stacked;
  uint32_t cindex;
  uint32_t *comp;
  uint32_t ccomp;
  struct stack *stack;
};

struct tjstate* new_tjstate(uint32_t c){
  struct tjstate *ans=malloc(sizeof(struct tjstate));
  ans->index=(uint32_t*)malloc(sizeof(uint32_t)*c);
  ans->lowlink=(uint32_t*)malloc(sizeof(uint32_t)*c);
  ans->stacked=(bool*)malloc(sizeof(bool)*c);
  ans->comp=(uint32_t*)malloc(sizeof(uint32_t)*c);
  ans->stack=new_stack(c);
  ans->cindex=1;
  ans->ccomp=0;
  for(uint32_t e=0;e<c;e++){
    ans->index[e]=0;
    ans->stacked[e]=false;
  }
  return(ans);
}

void free_tjstate(struct tjstate *x){
  free_stack(x->stack);
  free(x->comp);
  free(x->stacked);
  free(x->lowlink);
  free(x->index);
  free(x);
}

void rec(uint32_t v,uint32_t *g,uint32_t c,struct tjstate *s){
  s->lowlink[v]=s->index[v]=s->cindex;
  s->cindex++;
  //TODO: Add to stack
  push_stack(s->stack,v);
  s->stacked[v]=true;

  for(uint32_t w=0;w<c;w++){
    if(g[c*v+w]){
      if(!s->index[w]){
        rec(w,g,c,s);
        s->lowlink[v]=(s->lowlink[v]<s->lowlink[w])?s->lowlink[v]:s->lowlink[w];
      }else{
        if(s->stacked[w]){
          s->lowlink[v]=(s->lowlink[v]<s->index[w])?s->lowlink[v]:s->index[w];
        }
      }
    }
  }

  if(s->lowlink[v]==s->index[v]){
    s->ccomp++;
    while(true){
      uint32_t w=pop_stack(s->stack);
      s->stacked[w]=false;
      s->comp[w]=s->ccomp;
      if(w==v) break;
    }
  }
}

void tarjan(uint32_t *g,uint32_t c,int *ans){
  struct tjstate *s=new_tjstate(c);

  for(uint32_t e=0;e<c;e++)
    if(!s->index[e])
      rec(e,g,c,s);

  for(uint32_t e=0;e<c;e++){
    ans[e]=s->comp[e];
  }
     
  free_tjstate(s);

  
  
}
