% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{varcov<-.tramME}
\alias{varcov<-.tramME}
\title{Set the values of the random effects covariance matrices of a tramME model.}
\usage{
\method{varcov}{tramME}(object, as.theta = FALSE, ...) <- value
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{as.theta}{Logical value, if \code{TRUE}, indicating that the new values are supplied
in their reparameterized form.}

\item{...}{Optional arguments (ignored).}

\item{value}{A list of positive definite covariance matrices.}
}
\value{
A new \code{tramME} object with the new coefficient values.
}
\description{
Sets the list containing the covariance matrices of a tramME model. The matrices have
to be positive definite. Just as in \code{"coef<-"}, when the function is called
on a fitted object, the function will remove the infromation about the optimization.
}
\details{
The supplied list has to be named with the same names as implied by the model.
Hence, it might be a good idea to call \code{varcov} first, and
modify this list to make sure that the input has the right structure.

The new values can also be supplied in a form that corresponds to the reparametrization
used by the \code{tramTMB} model (see the option \code{as.theta = TRUE}).

All random effects variance parameters must be supplied. When there are penalized smooth
terms in the model variance parameters corresponding to these should also be part of the
input list.
}
\examples{
data("sleepstudy", package = "lme4")
mod <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy, nofit = TRUE)
vc <- varcov(mod)
vc[[1]] <- matrix(c(1, 0, 0, 2), ncol = 2)
varcov(mod) <- vc
}
