% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_an.R
\name{ts_norm_an}
\alias{ts_norm_an}
\title{Adaptive Normalization}
\usage{
ts_norm_an(outliers = outliers_boxplot(), nw = 0)
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}

\item{nw}{integer: window size.}
}
\value{
A \code{ts_norm_an} object.
}
\description{
Transform data to a common scale while adapting to changes in
distribution over time (optionally over a trailing window).
}
\examples{
# time series to normalize
library(daltoolbox)
data(tsd)

# convert to sliding windows
ts <- ts_data(tsd$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_an()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
\references{
Ogasawara, E., Martinez, L. C., De Oliveira, D., Zimbrão, G., Pappa, G. L.,
Mattoso, M. (2010). Adaptive Normalization: A novel data normalization
approach for non-stationary time series. Proceedings of the International
Joint Conference on Neural Networks (IJCNN). doi:10.1109/IJCNN.2010.5596746
}
