% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_flow.R
\name{dtm_reverse}
\alias{dtm_reverse}
\title{Inverse operation of the document_term_matrix function}
\usage{
dtm_reverse(x)
}
\arguments{
\item{x}{an object as returned by \code{\link{document_term_matrix}}}
}
\value{
a data.frame with columns doc_id, term and freq where freq is just the value in each
cell of the \code{x}
}
\description{
Inverse operation of the \code{\link{document_term_matrix}} function. 
Creates frequency table which contains 1 row per document/term
}
\examples{
x <- data.frame(
 doc_id = c(1, 1, 2, 3, 4), 
 term = c("A", "C", "Z", "X", "G"), 
 freq = c(1, 5, 7, 10, 0))
dtm <- document_term_matrix(x)
dtm_reverse(dtm)
}
\seealso{
\code{\link{document_term_matrix}}
}
