% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_high_level_models.R
\name{umxEFA}
\alias{umxEFA}
\alias{umxFactanal}
\title{FIML-based Exploratory Factor Analysis (EFA)}
\usage{
umxEFA(
  x = NULL,
  factors = NULL,
  data = NULL,
  scores = c("none", "ML", "WeightedML", "Regression"),
  minManifests = NA,
  rotation = c("varimax", "promax", "none"),
  return = c("model", "loadings"),
  report = c("markdown", "html"),
  summary = FALSE,
  name = "efa",
  digits = 2,
  tryHard = c("no", "yes", "ordinal", "search"),
  n.obs = NULL,
  covmat = NULL
)
}
\arguments{
\item{x}{Either 1: data, 2: Right-hand-side ~ formula , 3: Vector of variable names, or 4: Name for the model.}

\item{factors}{Either number of factors to request or a vector of factor names.}

\item{data}{A dataframe you are modeling.}

\item{scores}{Type of scores to produce, if any. The default is none, "Regression" gives Thompson's scores. Other options are 'ML', 'WeightedML', Partial matching allows these names to be abbreviated.}

\item{minManifests}{The least number of variables required to return a score for a participant (Default = NA).}

\item{rotation}{A rotation to perform on the loadings (default  = "varimax" (orthogonal))}

\item{return}{by default, the resulting MxModel is returned. Say "loadings" to get a fact.anal object.}

\item{report}{Report as markdown to the console, or open a table in browser ("html")}

\item{summary}{run \code{\link[=umxSummary]{umxSummary()}} on the underlying umxRAM model? (Default = FALSE)}

\item{name}{A name for your model (default = efa)}

\item{digits}{rounding (default = 2)}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{n.obs}{Number of observations in if covmat provided (default = NA)}

\item{covmat}{Covariance matrix of data you are modeling (not implemented)}
}
\value{
\itemize{
\item EFA \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}
}
}
\description{
Perform full-information maximum-likelihood factor analysis on a data matrix.
}
\details{
As in \code{\link[=factanal]{factanal()}}, you need only specify the number of factors and offer up
some manifest data, e.g:

\code{umxEFA(factors = 2, data = mtcars)}

Equivalently, you can also give a list of factor names:

\code{umxEFA(factors = c("g", "v"), data = mtcars)}

The factor model is implemented as a structural equation model, e.g.

\if{html}{\figure{umxEFA.png}{options: style="width: 50\%;" alt="Figure: umxEFA.png"}}
\if{latex}{\figure{umxEFA.pdf}{options: width=7cm}}

You can request \code{scores} from the model. Unlike factanal, these can cope with missing data.

You can also rotate the factors using any rotation function.

In an EFA, all items may load on all factors.

Should work with rotations provided in \code{libs("GPArotation")} and \code{libs("psych")}, e.g.,

\strong{Orthogonal}: "varimax", "quartimax", "bentlerT", "equamax", "varimin", "geominT" and "bifactor"
\strong{Oblique}: "Promax", "promax", "oblimin", "simplimax", "bentlerQ", "geominQ", "biquartimin" and "cluster"

For identification we need \ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}} degrees of freedom.
We get m(m+1)/2 from fixing factor variances to 1 and covariances to 0.
We get another m(m-1)/2 degrees of freedom by fixing the upper-right hand corner of
the factor loadings component of the A matrix at 0.

To aid optimization, manifest residual variances are \code{lbounded} at 0.

EFA reports standardized loadings: to do this, we scale the data.

\emph{note}: Bear in mind that factor scores are indeterminate (can be rotated to an infinity of equivalent solutions).

Thanks to @ConorDolan for code implementing the rotation matrix and other suggestions!
}
\examples{
\dontrun{
myVars = c("mpg", "disp", "hp", "wt", "qsec")
m1 = umxEFA(mtcars[, myVars], factors =   2, rotation = "promax")
# By default, returns the model
umx_is_MxModel(m1) # TRUE
# The loadings are stashed in the model:
loadings(m1)

# Formula interface in umxEFA
m2 = umxEFA(~ mpg + disp + hp + wt + qsec, factors = 2, rotation = "promax", data = mtcars)
loadings(m2)

# base-R factanal Formula interface for comparison
m2 = factanal(~ mpg + disp + hp + wt + qsec, factors = 2, rotation = "promax", data = mtcars)
loadings(m2)

# Return the loadings object
x = umxEFA(mtcars[, myVars], factors = 2, return = "loadings")
names(x) # "loadings" "rotmat"

# scores requested, so these will be returned
x = umxEFA(name = "score", factors = "g", data = mtcars[, myVars], scores= "Regression")
head(x)
#       g
# 1  -0.48059346
# 2  -0.42354000
# 3  -0.87078110

m1 = umxEFA(myVars, factors = 2, data = mtcars, rotation = "promax")
m1 = umxEFA(name = "named", factors = "g", data = mtcars[, myVars])
m1 = umxEFA(name = "by_number", factors = 2, rotation = "promax", data = mtcars[, myVars])

}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx},
}

Hendrickson, A. E. and White, P. O. (1964). Promax: a quick method for rotation to orthogonal oblique structure. \emph{British Journal of Statistical Psychology}, \strong{17}, 65–70. \doi{10.1111/j.2044-8317.1964.tb00244.x}.

Kaiser, H. F. (1958). The varimax criterion for analytic rotation in factor analysis. \emph{Psychometrika}, \strong{23}, 187–200. \doi{10.1007/BF02289233}.
}
\seealso{
\itemize{
\item \code{\link[=factanal]{factanal()}}, \code{\link[OpenMx:mxFactorScores]{OpenMx::mxFactorScores()}}
}

Other Super-easy helpers: 
\code{\link{umx}},
\code{\link{umxTwoStage}()}
}
\concept{Super-easy helpers}
