% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Newfoundland.R
\docType{data}
\name{mun_1}
\alias{mun_1}
\title{Colors of the University Memorial University of Newfoundland, Canada}
\format{
An object of class \code{character} of length 6.
}
\source{
Color definitions are based on the
\href{https://www.mun.ca/marcomm/media/production/memorial/administrative/marcomm/files/BrandStandards_August_2017_FA.pdf}{Brand standard manual (PDF)}.
}
\usage{
mun_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{mun_1} provides the University color and the 5 primary colors 
of the \href{https://www.mun.ca/}{Memorial University of Newfoundland} (MUN), Canada.
}
\details{
The University color is
\code{"PMS_202"} (defined as RGB 134/38/51, HEX #862633).

The five primary colors of MUN are
\code{"black_mun"}   (defined as RGB 35/31/32, HEX #231F20),
\code{"cool_gry_10"} (defined as RGB 99/102/106, HEX #323232),
\code{"cool_grey_7"} (defined as RGB 151/153/155, HEX #97999B),
\code{"warm_grey_6"} (defined as RGB 165/156/148, HEX #A59C94), and
\code{"warm_grey_8"} (defined as RGB 140/130/121, HEX #8C8279).

\code{mun_1} uses the HEX color definitions.
}
\examples{
mun_1
unikn::seecol(mun_1, 
              main = "Memorial University of Newfoundland 1") # view color palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-12-07.
}
\concept{Canadian university color palettes}
\keyword{datasets}
