% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsk_Rho.R
\name{vsk_Rho}
\alias{vsk_Rho}
\title{Estimating Vasicek Rho parameter by assuming the know P parameter}
\usage{
vsk_Rho(x, p)
}
\arguments{
\item{x}{A numeric vector in the (0, 1) interval that is supposed to
follow the Vasicek distribution}

\item{p}{A numeric vector in the (0, 1) interval. p has the same length
as x. Each value of p can be a constant or varying.}
}
\value{
A scalar representing the Rho parameter in the Vasicek distribution.
}
\description{
The function \code{vsk_Rho} estimates Rho parameter in the Vasicek
distribution by using maximum likelihood estimator, assuming the
known P parameter.
}
\examples{
x <- vsk_rvs(1000, Rho = 0.2, P = 0.1)
p <- rep(mean(x), length(x))
vsk_Rho(x, p)
# 0.2110976
}
