% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_counts_items}
\alias{tab_counts_items}
\title{Output frequencies for multiple variables}
\usage{
tab_counts_items(
  data,
  cols,
  ci = FALSE,
  percent = TRUE,
  values = c("n", "p"),
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{ci}{Whether to compute 95\% confidence intervals.}

\item{percent}{Set to FALSE to prevent calculating percents from proportions.}

\item{values}{The values to output: n (frequency) or p (percentage) or both (the default).}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{tab_counts}.}
}
\value{
A volker tibble.
}
\description{
Output frequencies for multiple variables
}
\examples{
library(volker)
data <- volker::chatgpt

tab_counts_items(data, starts_with("cg_adoption_"))

}
\keyword{internal}
