% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_radar_imagery.R
\name{get_radar_imagery}
\alias{get_radar_imagery}
\title{Get BOM Radar Imagery}
\usage{
get_radar_imagery(product_id, path = NULL, download_only = FALSE)
}
\arguments{
\item{product_id}{\code{Character}. \acronym{BOM} product ID to download and
import.  Value is required.}

\item{path}{\code{Character}. A character string with the name where the
downloaded file is saved.  If not provided, the default value \code{NULL} is
used which saves the file in an \R session temp directory.}

\item{download_only}{\code{Boolean}. Whether the radar image is loaded into the
environment as a \CRANpkg{magick} object or just downloaded.  Defaults to
\code{FALSE}}
}
\value{
A \CRANpkg{magick} object of the most recent \acronym{radar} image snapshot
published by the \acronym{BOM}.  If \code{download_only = TRUE} there will be
a \code{NULL} return value with the download path printed in the console as a
message.
}
\description{
Fetch \acronym{BOM} radar imagery from \url{ftp://ftp.bom.gov.au/anon/gen/radar/}
and return a \CRANpkg{magick} image object.  Files available are the
most recent radar snapshot which are updated approximately every 6 to 10
minutes.  It is suggested to check file availability first by using
\code{\link[=get_available_radar]{get_available_radar()}}.
}
\details{
Valid \acronym{BOM} \acronym{Radar} Product IDs for radar imagery
can be obtained from \code{\link[=get_available_radar]{get_available_radar()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Fetch most recent radar image for Wollongong 256km radar
imagery <- get_radar_imagery(product_id = "IDR032")
imagery
\dontshow{\}) # examplesIf}
}
\references{
Australian Bureau of Meteorology (\acronym{BOM}) radar images\cr
\url{http://www.bom.gov.au/australia/radar/}
}
\seealso{
\code{\link[=get_available_radar]{get_available_radar()}}

Other BOM: 
\code{\link{find_forecast_towns}()},
\code{\link{get_ag_bulletin}()},
\code{\link{get_available_imagery}()},
\code{\link{get_available_radar}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_satellite_imagery}()},
\code{\link{parse_ag_bulletin}()},
\code{\link{parse_coastal_forecast}()},
\code{\link{parse_precis_forecast}()}

Other data fetching: 
\code{\link{get_ag_bulletin}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_data_drill}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_patched_point}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_satellite_imagery}()}
}
\author{
Dean Marchiori, \email{deanmarchiori@gmail.com}
}
\concept{BOM}
\concept{data fetching}
