% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numSummary.R
\name{numSummaryTable}
\alias{numSummaryTable}
\title{Make a table showing numerical summary}
\usage{
numSummaryTable(
  x,
  ...,
  lang = getOption("numSummaryTable.lang", "en"),
  vanilla = FALSE,
  add.rownames = NULL
)
}
\arguments{
\item{x}{A grouped_df or a data.frame or a vector}

\item{...}{further argument to be passed}

\item{lang}{Language. choices are one of c("en","kor")}

\item{vanilla}{Logical. Whether make vanilla table or not}

\item{add.rownames}{Logical. Whether or not add rownames}
}
\description{
Make a table showing numerical summary
}
\examples{
require(moonBook)
require(dplyr)
numSummaryTable(acs)
numSummaryTable(acs$age)
acs \%>\% group_by(sex) \%>\% select(age) \%>\% numSummaryTable
acs \%>\% group_by(sex) \%>\% select(age,EF) \%>\% numSummaryTable
acs \%>\% group_by(sex,Dx) \%>\% select(age,EF) \%>\% numSummaryTable(vanilla=FALSE)
acs \%>\% group_by(sex,Dx) \%>\% numSummaryTable(age,EF,add.rownames=FALSE)
}
