// Generated by rstantools.  Do not edit by hand.

/*
    winputall is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    winputall is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with winputall.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_mhrw_allx_ind_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 129> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 82, column 2 to column 34)",
  " (in 'string', line 83, column 2 to column 28)",
  " (in 'string', line 84, column 2 to column 57)",
  " (in 'string', line 85, column 2 to column 42)",
  " (in 'string', line 87, column 2 to column 64)",
  " (in 'string', line 88, column 2 to column 35)",
  " (in 'string', line 89, column 2 to column 56)",
  " (in 'string', line 90, column 2 to column 69)",
  " (in 'string', line 91, column 2 to column 40)",
  " (in 'string', line 92, column 2 to column 13)",
  " (in 'string', line 93, column 2 to column 11)",
  " (in 'string', line 94, column 2 to column 11)",
  " (in 'string', line 95, column 2 to column 9)",
  " (in 'string', line 96, column 2 to column 9)",
  " (in 'string', line 97, column 2 to column 22)",
  " (in 'string', line 100, column 2 to column 12)",
  " (in 'string', line 86, column 2 to column 35)",
  " (in 'string', line 98, column 2 to column 15)",
  " (in 'string', line 99, column 2 to column 25)",
  " (in 'string', line 102, column 4 to column 87)",
  " (in 'string', line 103, column 4 to column 54)",
  " (in 'string', line 104, column 4 to column 27)",
  " (in 'string', line 105, column 4 to column 53)",
  " (in 'string', line 106, column 4 to column 66)",
  " (in 'string', line 107, column 4 to column 37)",
  " (in 'string', line 108, column 4 to column 18)",
  " (in 'string', line 109, column 4 to column 34)",
  " (in 'string', line 110, column 4 to column 28)",
  " (in 'string', line 119, column 6 to column 42)",
  " (in 'string', line 120, column 6 to column 41)",
  " (in 'string', line 121, column 6 to column 22)",
  " (in 'string', line 117, column 11 to line 122, column 5)",
  " (in 'string', line 113, column 6 to column 38)",
  " (in 'string', line 114, column 6 to column 16)",
  " (in 'string', line 115, column 6 to column 30)",
  " (in 'string', line 116, column 6 to column 36)",
  " (in 'string', line 111, column 16 to line 117, column 5)",
  " (in 'string', line 111, column 4 to line 122, column 5)",
  " (in 'string', line 123, column 4 to column 49)",
  " (in 'string', line 127, column 6 to column 18)",
  " (in 'string', line 126, column 41 to line 128, column 5)",
  " (in 'string', line 126, column 11 to line 128, column 5)",
  " (in 'string', line 125, column 7 to column 19)",
  " (in 'string', line 124, column 34 to line 126, column 5)",
  " (in 'string', line 124, column 4 to line 128, column 5)",
  " (in 'string', line 129, column 4 to column 11)",
  " (in 'string', line 101, column 22 to line 130, column 3)",
  " (in 'string', line 101, column 2 to line 130, column 3)",
  " (in 'string', line 67, column 2 to column 17)",
  " (in 'string', line 68, column 2 to column 17)",
  " (in 'string', line 69, column 2 to column 22)",
  " (in 'string', line 70, column 9 to column 10)",
  " (in 'string', line 70, column 2 to column 14)",
  " (in 'string', line 71, column 9 to column 10)",
  " (in 'string', line 71, column 11 to column 14)",
  " (in 'string', line 71, column 2 to column 22)",
  " (in 'string', line 72, column 9 to column 12)",
  " (in 'string', line 72, column 2 to column 20)",
  " (in 'string', line 73, column 9 to column 12)",
  " (in 'string', line 73, column 13 to column 16)",
  " (in 'string', line 73, column 2 to column 24)",
  " (in 'string', line 74, column 9 to column 10)",
  " (in 'string', line 74, column 11 to column 12)",
  " (in 'string', line 74, column 2 to column 21)",
  " (in 'string', line 75, column 2 to column 21)",
  " (in 'string', line 76, column 9 to column 12)",
  " (in 'string', line 76, column 2 to column 26)",
  " (in 'string', line 77, column 9 to column 12)",
  " (in 'string', line 77, column 14 to column 17)",
  " (in 'string', line 77, column 2 to column 36)",
  " (in 'string', line 82, column 9 to column 15)",
  " (in 'string', line 82, column 17 to column 20)",
  " (in 'string', line 83, column 9 to column 15)",
  " (in 'string', line 84, column 9 to column 15)",
  " (in 'string', line 85, column 9 to column 12)",
  " (in 'string', line 87, column 9 to column 12)",
  " (in 'string', line 88, column 9 to column 10)",
  " (in 'string', line 7, column 4 to column 27)",
  " (in 'string', line 8, column 11 to column 16)",
  " (in 'string', line 8, column 4 to column 24)",
  " (in 'string', line 17, column 8 to column 37)",
  " (in 'string', line 16, column 23 to line 18, column 7)",
  " (in 'string', line 16, column 6 to line 18, column 7)",
  " (in 'string', line 15, column 36 to line 19, column 5)",
  " (in 'string', line 15, column 11 to line 19, column 5)",
  " (in 'string', line 13, column 6 to column 19)",
  " (in 'string', line 12, column 36 to line 15, column 5)",
  " (in 'string', line 12, column 11 to line 19, column 5)",
  " (in 'string', line 10, column 6 to column 24)",
  " (in 'string', line 9, column 29 to line 12, column 5)",
  " (in 'string', line 9, column 4 to line 19, column 5)",
  " (in 'string', line 20, column 4 to column 17)",
  " (in 'string', line 5, column 53 to line 21, column 3)",
  " (in 'string', line 24, column 4 to column 11)",
  " (in 'string', line 27, column 4 to column 11)",
  " (in 'string', line 29, column 6 to column 18)",
  " (in 'string', line 28, column 19 to line 30, column 5)",
  " (in 'string', line 28, column 4 to line 30, column 5)",
  " (in 'string', line 31, column 4 to column 14)",
  " (in 'string', line 23, column 25 to line 32, column 3)",
  " (in 'string', line 35, column 11 to column 12)",
  " (in 'string', line 35, column 14 to column 15)",
  " (in 'string', line 35, column 4 to column 19)",
  " (in 'string', line 36, column 4 to column 10)",
  " (in 'string', line 37, column 4 to column 10)",
  " (in 'string', line 40, column 8 to column 23)",
  " (in 'string', line 42, column 10 to column 28)",
  " (in 'string', line 41, column 20 to line 43, column 9)",
  " (in 'string', line 41, column 8 to line 43, column 9)",
  " (in 'string', line 44, column 8 to column 18)",
  " (in 'string', line 39, column 21 to line 45, column 7)",
  " (in 'string', line 39, column 6 to line 45, column 7)",
  " (in 'string', line 38, column 19 to line 46, column 5)",
  " (in 'string', line 38, column 4 to line 46, column 5)",
  " (in 'string', line 47, column 4 to column 13)",
  " (in 'string', line 34, column 43 to line 48, column 3)",
  " (in 'string', line 51, column 11 to column 31)",
  " (in 'string', line 51, column 4 to column 35)",
  " (in 'string', line 52, column 4 to column 10)",
  " (in 'string', line 53, column 4 to column 10)",
  " (in 'string', line 58, column 8 to column 23)",
  " (in 'string', line 59, column 8 to column 18)",
  " (in 'string', line 57, column 21 to line 60, column 7)",
  " (in 'string', line 57, column 6 to line 60, column 7)",
  " (in 'string', line 56, column 25 to line 61, column 5)",
  " (in 'string', line 56, column 4 to line 61, column 5)",
  " (in 'string', line 62, column 4 to column 13)",
  " (in 'string', line 50, column 36 to line 63, column 3)"};
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
mod_rp_fun(const T0__& beta_arg__, const int& distrib_method, std::ostream*
           pstream__);
int symmat_size(const int& n, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,-1>
vector_to_symmat(const T0__& x_arg__, const int& n, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
symmat_to_vector(const T0__& x_arg__, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
mod_rp_fun(const T0__& beta_arg__, const int& distrib_method, std::ostream*
           pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& beta = stan::math::to_ref(beta_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int nb_rp = std::numeric_limits<int>::min();
    current_statement__ = 78;
    nb_rp = stan::math::size(beta);
    current_statement__ = 79;
    stan::math::validate_non_negative_index("tbeta", "nb_rp", nb_rp);
    Eigen::Matrix<local_scalar_t__,-1,1> tbeta =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nb_rp, DUMMY_VAR__);
    current_statement__ = 91;
    if (stan::math::logical_eq(distrib_method, 1)) {
      current_statement__ = 89;
      stan::model::assign(tbeta, stan::math::exp(beta),
        "assigning variable tbeta");
    } else {
      current_statement__ = 88;
      if (stan::math::logical_eq(distrib_method, 2)) {
        current_statement__ = 86;
        stan::model::assign(tbeta, beta, "assigning variable tbeta");
      } else {
        current_statement__ = 85;
        if (stan::math::logical_eq(distrib_method, 3)) {
          current_statement__ = 83;
          for (int i = 1; i <= nb_rp; ++i) {
            current_statement__ = 81;
            stan::model::assign(tbeta,
              stan::math::fmax(0,
                stan::model::rvalue(beta, "beta", stan::model::index_uni(i))),
              "assigning variable tbeta", stan::model::index_uni(i));
          }
        }
      }
    }
    current_statement__ = 92;
    return tbeta;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
int symmat_size(const int& n, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int sz = std::numeric_limits<int>::min();
    current_statement__ = 95;
    sz = 0;
    current_statement__ = 98;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 96;
      sz = (sz + i);
    }
    current_statement__ = 99;
    return sz;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,-1>
vector_to_symmat(const T0__& x_arg__, const int& n, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 101;
    stan::math::validate_non_negative_index("m", "n", n);
    current_statement__ = 102;
    stan::math::validate_non_negative_index("m", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,-1> m =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n, n, DUMMY_VAR__);
    int k = std::numeric_limits<int>::min();
    current_statement__ = 105;
    k = 1;
    current_statement__ = 114;
    for (int j = 1; j <= n; ++j) {
      current_statement__ = 112;
      for (int i = 1; i <= j; ++i) {
        current_statement__ = 106;
        stan::model::assign(m,
          stan::model::rvalue(x, "x", stan::model::index_uni(k)),
          "assigning variable m", stan::model::index_uni(i),
          stan::model::index_uni(j));
        current_statement__ = 109;
        if (stan::math::logical_neq(i, j)) {
          current_statement__ = 107;
          stan::model::assign(m,
            stan::model::rvalue(m, "m", stan::model::index_uni(i),
              stan::model::index_uni(j)), "assigning variable m",
            stan::model::index_uni(j), stan::model::index_uni(i));
        }
        current_statement__ = 110;
        k = (k + 1);
      }
    }
    current_statement__ = 115;
    return m;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
symmat_to_vector(const T0__& x_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 117;
    stan::math::validate_non_negative_index("v", "symmat_size(rows(x))",
      symmat_size(stan::math::rows(x), pstream__));
    Eigen::Matrix<local_scalar_t__,-1,1> v =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(symmat_size(
                                                       stan::math::rows(x),
                                                       pstream__),
        DUMMY_VAR__);
    int k = std::numeric_limits<int>::min();
    current_statement__ = 120;
    k = 1;
    current_statement__ = 126;
    for (int j = 1; j <= stan::math::rows(x); ++j) {
      current_statement__ = 124;
      for (int i = 1; i <= j; ++i) {
        current_statement__ = 121;
        stan::model::assign(v,
          stan::model::rvalue(x, "x", stan::model::index_uni(i),
            stan::model::index_uni(j)), "assigning variable v",
          stan::model::index_uni(k));
        current_statement__ = 122;
        k = (k + 1);
      }
    }
    current_statement__ = 127;
    return v;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_mhrw_allx_ind final : public model_base_crtp<model_mhrw_allx_ind> {
private:
  int T;
  int K;
  int nb_sim;
  Eigen::Matrix<double,-1,1> y_data__;
  Eigen::Matrix<double,-1,-1> big_s_data__;
  Eigen::Matrix<double,-1,1> alpha_data__;
  Eigen::Matrix<double,-1,-1> omega_data__;
  Eigen::Matrix<double,-1,-1> sigma_data__;
  int distrib_method;
  Eigen::Matrix<double,-1,1> start_value_data__;
  Eigen::Matrix<double,-1,-1> omega_importance_data__;
  int beta_accept_2dim__;
  int beta_proposed_1dim__;
  int tbeta_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> big_s{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> alpha{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> omega{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> sigma{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> start_value{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> omega_importance{nullptr, 0, 0};
public:
  ~model_mhrw_allx_ind() {}
  model_mhrw_allx_ind(stan::io::var_context& context__, unsigned int
                      random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_mhrw_allx_ind_namespace::model_mhrw_allx_ind";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 49;
      context__.validate_dims("data initialization", "T", "int",
        std::vector<size_t>{});
      T = std::numeric_limits<int>::min();
      current_statement__ = 49;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 49;
      stan::math::check_greater_or_equal(function__, "T", T, 0);
      current_statement__ = 50;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 50;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 50;
      stan::math::check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 51;
      context__.validate_dims("data initialization", "nb_sim", "int",
        std::vector<size_t>{});
      nb_sim = std::numeric_limits<int>::min();
      current_statement__ = 51;
      nb_sim = context__.vals_i("nb_sim")[(1 - 1)];
      current_statement__ = 51;
      stan::math::check_greater_or_equal(function__, "nb_sim", nb_sim, 0);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("y", "T", T);
      current_statement__ = 53;
      context__.validate_dims("data initialization", "y", "double",
        std::vector<size_t>{static_cast<size_t>(T)});
      y_data__ = Eigen::Matrix<double,-1,1>::Constant(T,
                   std::numeric_limits<double>::quiet_NaN());
      new (&y) Eigen::Map<Eigen::Matrix<double,-1,1>>(y_data__.data(), T);
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 53;
        y_flat__ = context__.vals_r("y");
        current_statement__ = 53;
        pos__ = 1;
        current_statement__ = 53;
        for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
          current_statement__ = 53;
          stan::model::assign(y, y_flat__[(pos__ - 1)],
            "assigning variable y", stan::model::index_uni(sym1__));
          current_statement__ = 53;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 54;
      stan::math::validate_non_negative_index("big_s", "T", T);
      current_statement__ = 55;
      stan::math::validate_non_negative_index("big_s", "T * K", (T * K));
      current_statement__ = 56;
      context__.validate_dims("data initialization", "big_s", "double",
        std::vector<size_t>{static_cast<size_t>(T),
          static_cast<size_t>((T * K))});
      big_s_data__ = Eigen::Matrix<double,-1,-1>::Constant(T, (T * K),
                       std::numeric_limits<double>::quiet_NaN());
      new (&big_s)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(big_s_data__.data(), T, (T *
        K));
      {
        std::vector<local_scalar_t__> big_s_flat__;
        current_statement__ = 56;
        big_s_flat__ = context__.vals_r("big_s");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= (T * K); ++sym1__) {
          current_statement__ = 56;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 56;
            stan::model::assign(big_s, big_s_flat__[(pos__ - 1)],
              "assigning variable big_s", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 56;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 57;
      stan::math::validate_non_negative_index("alpha", "T * K", (T * K));
      current_statement__ = 58;
      context__.validate_dims("data initialization", "alpha", "double",
        std::vector<size_t>{static_cast<size_t>((T * K))});
      alpha_data__ = Eigen::Matrix<double,-1,1>::Constant((T * K),
                       std::numeric_limits<double>::quiet_NaN());
      new (&alpha)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(alpha_data__.data(), (T * K));
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 58;
        alpha_flat__ = context__.vals_r("alpha");
        current_statement__ = 58;
        pos__ = 1;
        current_statement__ = 58;
        for (int sym1__ = 1; sym1__ <= (T * K); ++sym1__) {
          current_statement__ = 58;
          stan::model::assign(alpha, alpha_flat__[(pos__ - 1)],
            "assigning variable alpha", stan::model::index_uni(sym1__));
          current_statement__ = 58;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 59;
      stan::math::validate_non_negative_index("omega", "T * K", (T * K));
      current_statement__ = 60;
      stan::math::validate_non_negative_index("omega", "T * K", (T * K));
      current_statement__ = 61;
      context__.validate_dims("data initialization", "omega", "double",
        std::vector<size_t>{static_cast<size_t>((T * K)),
          static_cast<size_t>((T * K))});
      omega_data__ = Eigen::Matrix<double,-1,-1>::Constant((T * K), (T * K),
                       std::numeric_limits<double>::quiet_NaN());
      new (&omega)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(omega_data__.data(), (T * K),
        (T * K));
      {
        std::vector<local_scalar_t__> omega_flat__;
        current_statement__ = 61;
        omega_flat__ = context__.vals_r("omega");
        current_statement__ = 61;
        pos__ = 1;
        current_statement__ = 61;
        for (int sym1__ = 1; sym1__ <= (T * K); ++sym1__) {
          current_statement__ = 61;
          for (int sym2__ = 1; sym2__ <= (T * K); ++sym2__) {
            current_statement__ = 61;
            stan::model::assign(omega, omega_flat__[(pos__ - 1)],
              "assigning variable omega", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 61;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 62;
      stan::math::validate_non_negative_index("sigma", "T", T);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("sigma", "T", T);
      current_statement__ = 64;
      context__.validate_dims("data initialization", "sigma", "double",
        std::vector<size_t>{static_cast<size_t>(T), static_cast<size_t>(T)});
      sigma_data__ = Eigen::Matrix<double,-1,-1>::Constant(T, T,
                       std::numeric_limits<double>::quiet_NaN());
      new (&sigma)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(sigma_data__.data(), T, T);
      {
        std::vector<local_scalar_t__> sigma_flat__;
        current_statement__ = 64;
        sigma_flat__ = context__.vals_r("sigma");
        current_statement__ = 64;
        pos__ = 1;
        current_statement__ = 64;
        for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
          current_statement__ = 64;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 64;
            stan::model::assign(sigma, sigma_flat__[(pos__ - 1)],
              "assigning variable sigma", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 64;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 65;
      context__.validate_dims("data initialization", "distrib_method", "int",
        std::vector<size_t>{});
      distrib_method = std::numeric_limits<int>::min();
      current_statement__ = 65;
      distrib_method = context__.vals_i("distrib_method")[(1 - 1)];
      current_statement__ = 66;
      stan::math::validate_non_negative_index("start_value", "T * K", (T * K));
      current_statement__ = 67;
      context__.validate_dims("data initialization", "start_value", "double",
        std::vector<size_t>{static_cast<size_t>((T * K))});
      start_value_data__ = Eigen::Matrix<double,-1,1>::Constant((T * K),
                             std::numeric_limits<double>::quiet_NaN());
      new (&start_value)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(start_value_data__.data(), (T
        * K));
      {
        std::vector<local_scalar_t__> start_value_flat__;
        current_statement__ = 67;
        start_value_flat__ = context__.vals_r("start_value");
        current_statement__ = 67;
        pos__ = 1;
        current_statement__ = 67;
        for (int sym1__ = 1; sym1__ <= (T * K); ++sym1__) {
          current_statement__ = 67;
          stan::model::assign(start_value, start_value_flat__[(pos__ - 1)],
            "assigning variable start_value", stan::model::index_uni(sym1__));
          current_statement__ = 67;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 68;
      stan::math::validate_non_negative_index("omega_importance", "T * K", (T
        * K));
      current_statement__ = 69;
      stan::math::validate_non_negative_index("omega_importance", "T * K", (T
        * K));
      current_statement__ = 70;
      context__.validate_dims("data initialization", "omega_importance",
        "double",
        std::vector<size_t>{static_cast<size_t>((T * K)),
          static_cast<size_t>((T * K))});
      omega_importance_data__ = Eigen::Matrix<double,-1,-1>::Constant((T *
                                  K), (T * K),
                                  std::numeric_limits<double>::quiet_NaN());
      new (&omega_importance)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(omega_importance_data__.data(),
        (T * K), (T * K));
      {
        std::vector<local_scalar_t__> omega_importance_flat__;
        current_statement__ = 70;
        omega_importance_flat__ = context__.vals_r("omega_importance");
        current_statement__ = 70;
        pos__ = 1;
        current_statement__ = 70;
        for (int sym1__ = 1; sym1__ <= (T * K); ++sym1__) {
          current_statement__ = 70;
          for (int sym2__ = 1; sym2__ <= (T * K); ++sym2__) {
            current_statement__ = 70;
            stan::model::assign(omega_importance,
              omega_importance_flat__[(pos__ - 1)],
              "assigning variable omega_importance",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 70;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 71;
      stan::math::validate_non_negative_index("beta_accept", "nb_sim", nb_sim);
      current_statement__ = 72;
      beta_accept_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 72;
      beta_accept_2dim__ = (T * K);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("beta_accept", "T * K",
        beta_accept_2dim__);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("log_p_mean", "nb_sim", nb_sim);
      current_statement__ = 74;
      stan::math::validate_non_negative_index("acceptance_rate", "nb_sim",
        nb_sim);
      current_statement__ = 75;
      beta_proposed_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 75;
      beta_proposed_1dim__ = (T * K);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("beta_proposed", "T * K",
        beta_proposed_1dim__);
      current_statement__ = 76;
      tbeta_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 76;
      tbeta_1dim__ = (T * K);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("tbeta", "T * K", tbeta_1dim__);
      current_statement__ = 77;
      stan::math::validate_non_negative_index("Xbeta", "T", T);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 0U;
  }
  inline std::string model_name() const final {
    return "model_mhrw_allx_ind";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_mhrw_allx_ind_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_mhrw_allx_ind_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,-1> beta_accept =
        Eigen::Matrix<double,-1,-1>::Constant(nb_sim, beta_accept_2dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> log_p_mean =
        Eigen::Matrix<double,-1,1>::Constant(nb_sim,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> acceptance_rate =
        Eigen::Matrix<double,-1,1>::Constant(nb_sim,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      stan::model::assign(acceptance_rate, stan::math::rep_vector(0, nb_sim),
        "assigning variable acceptance_rate");
      Eigen::Matrix<double,-1,1> beta_proposed =
        Eigen::Matrix<double,-1,1>::Constant(beta_proposed_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      stan::model::assign(beta_proposed, start_value,
        "assigning variable beta_proposed");
      current_statement__ = 17;
      stan::model::assign(beta_accept, stan::math::transpose(beta_proposed),
        "assigning variable beta_accept", stan::model::index_uni(1));
      Eigen::Matrix<double,-1,1> tbeta =
        Eigen::Matrix<double,-1,1>::Constant(tbeta_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      stan::model::assign(tbeta,
        mod_rp_fun(beta_proposed, distrib_method, pstream__),
        "assigning variable tbeta");
      Eigen::Matrix<double,-1,1> Xbeta =
        Eigen::Matrix<double,-1,1>::Constant(T,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 6;
      stan::model::assign(Xbeta, stan::math::multiply(big_s, tbeta),
        "assigning variable Xbeta");
      double log_pp_obs = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 7;
      log_pp_obs = stan::math::multi_normal_lpdf<false>(y, Xbeta, sigma);
      double log_pp_mix = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 8;
      log_pp_mix = stan::math::multi_normal_lpdf<false>(beta_proposed, alpha,
                     omega);
      double log_pp = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 9;
      log_pp = (log_pp_obs + log_pp_mix);
      double c = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 10;
      c = 1;
      double p_t = std::numeric_limits<double>::quiet_NaN();
      double p_p = std::numeric_limits<double>::quiet_NaN();
      double R = std::numeric_limits<double>::quiet_NaN();
      double u = std::numeric_limits<double>::quiet_NaN();
      int nb_accepted = std::numeric_limits<int>::min();
      current_statement__ = 15;
      nb_accepted = 0;
      current_statement__ = 18;
      p_t = log_pp;
      current_statement__ = 19;
      stan::model::assign(log_p_mean, log_pp,
        "assigning variable log_p_mean", stan::model::index_uni(1));
      int i = std::numeric_limits<int>::min();
      current_statement__ = 16;
      i = 2;
      current_statement__ = 48;
      while (stan::math::logical_lte(i, nb_sim)) {
        current_statement__ = 20;
        stan::model::assign(beta_proposed,
          stan::math::multi_normal_rng(
            stan::model::rvalue(beta_accept, "beta_accept",
              stan::model::index_uni((i - 1))),
            stan::math::multiply(stan::math::square(c), omega_importance),
            base_rng__), "assigning variable beta_proposed");
        current_statement__ = 21;
        stan::model::assign(tbeta,
          mod_rp_fun(beta_proposed, distrib_method, pstream__),
          "assigning variable tbeta");
        current_statement__ = 22;
        stan::model::assign(Xbeta, stan::math::multiply(big_s, tbeta),
          "assigning variable Xbeta");
        current_statement__ = 23;
        log_pp_obs = stan::math::multi_normal_lpdf<false>(y, Xbeta, sigma);
        current_statement__ = 24;
        log_pp_mix = stan::math::multi_normal_lpdf<false>(beta_proposed,
                       alpha, omega);
        current_statement__ = 25;
        log_pp = (log_pp_obs + log_pp_mix);
        current_statement__ = 26;
        p_p = log_pp;
        current_statement__ = 27;
        R = stan::math::fmin(1, stan::math::exp((p_p - p_t)));
        current_statement__ = 28;
        u = stan::math::uniform_rng(0, 1, base_rng__);
        current_statement__ = 38;
        if (stan::math::logical_lte(u, R)) {
          current_statement__ = 33;
          stan::model::assign(beta_accept,
            stan::math::transpose(beta_proposed),
            "assigning variable beta_accept", stan::model::index_uni(i));
          current_statement__ = 34;
          p_t = p_p;
          current_statement__ = 35;
          stan::model::assign(log_p_mean, log_pp,
            "assigning variable log_p_mean", stan::model::index_uni(i));
          current_statement__ = 36;
          nb_accepted = (nb_accepted + 1);
        } else {
          current_statement__ = 29;
          stan::model::assign(beta_accept,
            stan::model::deep_copy(
              stan::model::rvalue(beta_accept, "beta_accept",
                stan::model::index_uni((i - 1)))),
            "assigning variable beta_accept", stan::model::index_uni(i));
          current_statement__ = 30;
          stan::model::assign(log_p_mean,
            stan::model::rvalue(log_p_mean, "log_p_mean",
              stan::model::index_uni((i - 1))),
            "assigning variable log_p_mean", stan::model::index_uni(i));
          current_statement__ = 31;
          p_t = (p_t * 1.0);
        }
        current_statement__ = 39;
        stan::model::assign(acceptance_rate, ((nb_accepted * 1.0) / i),
          "assigning variable acceptance_rate", stan::model::index_uni(i));
        current_statement__ = 45;
        if (stan::math::logical_lt(
              stan::model::rvalue(acceptance_rate, "acceptance_rate",
                stan::model::index_uni(i)), 0.20)) {
          current_statement__ = 43;
          c = (c / 1.1);
        } else {
          current_statement__ = 42;
          if (stan::math::logical_gt(
                stan::model::rvalue(acceptance_rate, "acceptance_rate",
                  stan::model::index_uni(i)), 0.32)) {
            current_statement__ = 40;
            c = (c * 1.1);
          }
        }
        current_statement__ = 46;
        i = (i + 1);
      }
      out__.write(beta_accept);
      out__.write(log_p_mean);
      out__.write(acceptance_rate);
      out__.write(beta_proposed);
      out__.write(tbeta);
      out__.write(Xbeta);
      out__.write(log_pp_obs);
      out__.write(log_pp_mix);
      out__.write(log_pp);
      out__.write(c);
      out__.write(p_t);
      out__.write(p_p);
      out__.write(R);
      out__.write(u);
      out__.write(nb_accepted);
      out__.write(i);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string>
        temp{"beta_accept", "log_p_mean", "acceptance_rate", "beta_proposed",
             "tbeta", "Xbeta", "log_pp_obs", "log_pp_mix", "log_pp", "c",
             "p_t", "p_p", "R", "u", "nb_accepted", "i"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(nb_sim),
               static_cast<size_t>(beta_accept_2dim__)},
             std::vector<size_t>{static_cast<size_t>(nb_sim)},
             std::vector<size_t>{static_cast<size_t>(nb_sim)},
             std::vector<size_t>{static_cast<size_t>(beta_proposed_1dim__)},
             std::vector<size_t>{static_cast<size_t>(tbeta_1dim__)},
             std::vector<size_t>{static_cast<size_t>(T)},
             std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{}, std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= beta_accept_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nb_sim; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta_accept" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= nb_sim; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_p_mean" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nb_sim; ++sym1__) {
        param_names__.emplace_back(std::string() + "acceptance_rate" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= beta_proposed_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta_proposed" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= tbeta_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "tbeta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        param_names__.emplace_back(std::string() + "Xbeta" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "log_pp_obs");
      param_names__.emplace_back(std::string() + "log_pp_mix");
      param_names__.emplace_back(std::string() + "log_pp");
      param_names__.emplace_back(std::string() + "c");
      param_names__.emplace_back(std::string() + "p_t");
      param_names__.emplace_back(std::string() + "p_p");
      param_names__.emplace_back(std::string() + "R");
      param_names__.emplace_back(std::string() + "u");
      param_names__.emplace_back(std::string() + "nb_accepted");
      param_names__.emplace_back(std::string() + "i");
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= beta_accept_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nb_sim; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta_accept" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= nb_sim; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_p_mean" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= nb_sim; ++sym1__) {
        param_names__.emplace_back(std::string() + "acceptance_rate" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= beta_proposed_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta_proposed" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= tbeta_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "tbeta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        param_names__.emplace_back(std::string() + "Xbeta" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "log_pp_obs");
      param_names__.emplace_back(std::string() + "log_pp_mix");
      param_names__.emplace_back(std::string() + "log_pp");
      param_names__.emplace_back(std::string() + "c");
      param_names__.emplace_back(std::string() + "p_t");
      param_names__.emplace_back(std::string() + "p_p");
      param_names__.emplace_back(std::string() + "R");
      param_names__.emplace_back(std::string() + "u");
      param_names__.emplace_back(std::string() + "nb_accepted");
      param_names__.emplace_back(std::string() + "i");
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta_accept\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(nb_sim) + ",\"cols\":" + std::to_string(beta_accept_2dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"log_p_mean\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nb_sim) + "},\"block\":\"generated_quantities\"},{\"name\":\"acceptance_rate\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nb_sim) + "},\"block\":\"generated_quantities\"},{\"name\":\"beta_proposed\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(beta_proposed_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"tbeta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(tbeta_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"Xbeta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(T) + "},\"block\":\"generated_quantities\"},{\"name\":\"log_pp_obs\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"log_pp_mix\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"log_pp\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"c\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"p_t\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"p_p\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"R\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"u\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"nb_accepted\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"i\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"beta_accept\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(nb_sim) + ",\"cols\":" + std::to_string(beta_accept_2dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"log_p_mean\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nb_sim) + "},\"block\":\"generated_quantities\"},{\"name\":\"acceptance_rate\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nb_sim) + "},\"block\":\"generated_quantities\"},{\"name\":\"beta_proposed\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(beta_proposed_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"tbeta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(tbeta_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"Xbeta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(T) + "},\"block\":\"generated_quantities\"},{\"name\":\"log_pp_obs\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"log_pp_mix\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"log_pp\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"c\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"p_t\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"p_p\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"R\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"u\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"nb_accepted\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"i\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = 0;
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities *
      (((((((((((((((((nb_sim * beta_accept_2dim__) + nb_sim) + nb_sim) +
      beta_proposed_1dim__) + tbeta_1dim__) + T) + 1) + 1) + 1) + 1) + 1) +
      1) + 1) + 1) + 1) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = 0;
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities *
      (((((((((((((((((nb_sim * beta_accept_2dim__) + nb_sim) + nb_sim) +
      beta_proposed_1dim__) + tbeta_1dim__) + T) + 1) + 1) + 1) + 1) + 1) +
      1) + 1) + 1) + 1) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_mhrw_allx_ind_namespace::model_mhrw_allx_ind;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_mhrw_allx_ind_namespace::profiles__;
}
#endif
#endif
