% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataParse.R
\name{redcap.rune}
\alias{redcap.rune}
\title{Parse composite REDCap instrument into component data frames by variable prefix}
\usage{
redcap.rune(
  instrument_name,
  raw_or_label = "raw",
  redcap_event_name = NULL,
  batch_size = 1000,
  records = NULL,
  fields = NULL,
  pii = FALSE,
  interview_date = NULL,
  date_format = "ymd",
  lower = TRUE
)
}
\arguments{
\item{instrument_name}{Name of the REDCap instrument}

\item{raw_or_label}{Whether to return raw or labeled values}

\item{redcap_event_name}{Optional event name filter}

\item{batch_size}{Number of records to retrieve per batch}

\item{records}{Optional vector of specific record IDs}

\item{fields}{Optional vector of specific fields}

\item{pii}{Logical; if FALSE (default), remove fields marked as PII. TRUE keeps PII.}

\item{interview_date}{Optional; date filtering parameter}

\item{date_format}{Default ymd define date format for interview_date}

\item{lower}{default TRUE convert prefixes to lower case}
}
\value{
Creates multiple dataframes in the parent environment, one for each survey
detected in the data. Each dataframe is named after its survey prefix.
}
\description{
This function fetches a REDCap instrument and separates it into individual data frames
for each survey/collection detected in the data based on column name prefixes.
It identifies the appropriate identifier column and splits the data accordingly.
}
