% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptivityMutation.R
\name{IAMRate}
\alias{IAMRate}
\title{Individually adaptive mutation rate.}
\usage{
IAMRate(fit, lF)
}
\arguments{
\item{fit}{Fitness of gene.}

\item{lF}{Local configuration.}
}
\value{
Mutation rate of a gene depending on its fitness.
}
\description{
The probability of applying a mutation operator
             to a gene. The idea is that a gene selected for 
             reproduction whose fitness is 
             below a threshold value is mutated with a higher 
             probability to give it a chance.
}
\details{
The probability of applying a mutation operator is
         determined by a threshold: If the fitness of a gene
         is higher than \code{lF$CutoffFit()*lF$CBestFitness()},
         than return \code{lF$MutationRate1()} 
         else \code{lF$MutationRate2()}.

         Note that the idea is also applicable to gene specific 
         local mutation operators. For example, the bit mutation rate
         of mutation operators for binary genes.
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list()
lF$MutationRate1<-parm(0.20)
lF$MutationRate2<-parm(0.40)
lF$CutoffFit<-parm(0.60)
lF$CBestFitness=parm(105)
IAMRate(100, lF)
IAMRate(50, lF)
}
\references{
Stanhope, Stephen A. and Daida, Jason M. (1996)
  An Individually Variable Mutation-rate Strategy for Genetic Algorithms.
  In: Koza, John (Ed.)
  Late Breaking Papers at the Genetic Programming 1996 Conference.
  Stanford University Bookstore, Stanford, pp. 177-185.
  (ISBN:0-18-201-031-7)
}
\seealso{
Other Adaptive Rates: 
\code{\link{IACRate}()}
}
\concept{Adaptive Rates}
