% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{from_root}
\alias{from_root}
\title{Get the relative path of a path in a project relative to the current working
directory}
\usage{
from_root(..., root = proj_root(), error = TRUE)
}
\arguments{
\item{...}{A character vector of path components \emph{relative to the root
directory of the project}.}

\item{root}{The root directory of the project.}

\item{error}{Whether to signal an error if the path cannot be converted to a
relative path.}
}
\value{
A relative path, or an error when the project root directory cannot
be determined or the conversion failed and \code{error = TRUE}.
}
\description{
First compose an absolute path using the project root directory and the
relative path components, i.e., \code{\link{file.path}}\verb{(root, ...)}. Then
convert it to a relative path with \code{\link[=relative_path]{relative_path()}}, which is
relative to the current working directory.
}
\details{
This function was inspired by \code{here::here()}, and the major difference
is that it returns a relative path by default, which is more portable.
}
\examples{
\dontrun{
xfun::from_root("data", "mtcars.csv")
}
}
