% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtra_pars.R
\name{get_prm}
\alias{get_prm}
\title{Access model parameters}
\usage{
get_prm(
  xpdb,
  .problem = NULL,
  .subprob = NULL,
  .method = NULL,
  digits = 4,
  transform = TRUE,
  show_all = FALSE,
  quiet
)
}
\arguments{
\item{xpdb}{An \code{xpose_data} object from which the model output file data will be extracted.}

\item{.problem}{The problem to be used, by default returns the last one for each file.}

\item{.subprob}{The subproblem to be used, by default returns the last one for each file.}

\item{.method}{The estimation method to be used, by default returns the last one for each file}

\item{digits}{The number of significant digits to be displayed.}

\item{transform}{Should diagonal OMEGA and SIGMA elements be transformed to standard deviation and 
off diagonal elements be transformed to correlations.}

\item{show_all}{Logical, whether the 0 fixed off-diagonal elements should be removed from the output.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}
}
\value{
A tibble for single problem/subprob or a named list for multiple problem|subprob.
}
\description{
Access model parameter estimates from an xpdb object.

Methods have been added to implement extensions. See Details.
}
\details{
When using an <\code{xp_xtra}> object, this function will add a column to the output
where CV\% for each diagonal element of omega is calculated. This CV\% is with
respect to the resulting structural parameter, so unless the default log-normal
association is applicable update with \code{\link{add_prm_association}}.

For log-normal, users may prefer to use the first-order CV\% (\eqn{\sqrt{\omega^2}})
instead of the exact. In such case, \code{xpdb <- set_option(xpdb, cvtype="sqrt")} will
get that preferred form.

If a single omega parameter is associated with multiple fixed effect parameters,
the \code{cv} column will be a list. For the \code{omega} row associated with multiple
fixed effect parameters, there will be multiple CV values. This will be the case
even if the transformation is log-normal and therefore scale-invariant, given
the need for generality.

\strong{Note} the approach used to calculate CV\% assumes an untransformed scale for the
fitted parameter value (unrelated to \code{transform}=TRUE). That means, for example,
that for a logit-normal fitted parameter value, it is expected the value will be
something constrained between 0 and 1, not the unbounded, continuous transformed value.
The function <\code{\link{mutate_prm}}> is intended to help where that might be an issue.
}
\examples{

# xpose parameter table
get_prm(xpose::xpdb_ex_pk, .problem = 1)

# xpose.xtra parameter table (basically the same)
get_prm(pheno_final, .problem = 1)

# For the sake of example, even though these were all lognormal:
pheno_final \%>\%
  add_prm_association(CLpkg~logit(IIVCL)) \%>\%
  add_prm_association(Vpkg~nmboxcox(IIVV, lambda = 0.01)) \%>\%
  get_prm(.problem = 1)


}
\references{
Prybylski, J.P. Reporting Coefficient of Variation for Logit, Box-Cox and
Other Non-log-normal Parameters. Clin Pharmacokinet 63, 133-135 (2024).
\doi{doi:10.1007/s40262-023-01343-2}
}
\seealso{
\code{\link[=add_prm_association]{add_prm_association()}}
}
